/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.FieldPtrTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.MethodPtrTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.FieldEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeDefEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class TypeDefTable
extends AbstractTable {
    public static final int TABLE_INDEX = 2;
    public static final int MIN_ROW_SIZE = 14;
    private long[] typeAttributeFlags;
    private int[] typeNameStringIndex;
    private int[] typeNamespaceStringIndex;
    private long[] extendsCodedIndex;
    private int[] fieldListFieldIndex;
    private int[] methodListMethodIndex;
    private byte sizeOfExtendsIndex;
    private byte sizeOfFieldIndex;
    private byte sizeOfMethodIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.typeAttributeFlags = new long[this.rows];
        this.typeNameStringIndex = new int[this.rows];
        this.typeNamespaceStringIndex = new int[this.rows];
        this.extendsCodedIndex = new long[this.rows];
        this.fieldListFieldIndex = new int[this.rows];
        this.methodListMethodIndex = new int[this.rows];
        this.sizeOfExtendsIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.TypeDefOrRef);
        this.sizeOfFieldIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 4);
        this.sizeOfMethodIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 6);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.typeAttributeFlags[row] = ByteReader.getUInt32(data, offset);
        offset += 4;
        offset += this.readStringIndex(data, offset, this.typeNameStringIndex, row);
        offset += this.readStringIndex(data, offset, this.typeNamespaceStringIndex, row);
        offset += this.readIndex(data, offset, this.extendsCodedIndex, row, this.sizeOfExtendsIndex);
        offset += this.readIndex(data, offset, this.fieldListFieldIndex, row, this.sizeOfFieldIndex);
        offset += this.readIndex(data, offset, this.methodListMethodIndex, row, this.sizeOfMethodIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 14);
        return rowSize;
    }

    @Override
    public String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" TypeDef Table (2):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  TypeAttribute Flags: ");
            buffer.append(this.typeAttributeFlags[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.typeNameStringIndex[i]);
            buffer.append(";\tNameSpace StringIndex: ");
            buffer.append(this.typeNamespaceStringIndex[i]);
            buffer.append(";\tExtends CodedIndex: ");
            buffer.append(this.extendsCodedIndex[i]);
            buffer.append(";\tFieldList Index: ");
            buffer.append(this.fieldListFieldIndex[i]);
            buffer.append(";\tMethodList Index: ");
            buffer.append(this.methodListMethodIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 2;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        TypeDefEntry e = (TypeDefEntry)entry[index];
        e.setFlags(this.typeAttributeFlags[index]);
        String className = s.getString(this.typeNameStringIndex[index]);
        if (className != null) {
            if (className.contains(">e__FixedBuffer")) {
                e.setName("'" + className + "'");
            } else {
                e.setName(className);
            }
        }
        e.setNamespace(s.getString(this.typeNamespaceStringIndex[index]));
        e.setExtends(EntryDecoder.getTypeDefOrRefEntry(model, this.extendsCodedIndex[index]));
        FieldPtrTable fieldPtr = (FieldPtrTable)m.getMetadataTable()[3];
        int offset = this.fieldListFieldIndex[index];
        if (offset > 0 && offset <= model.field.length) {
            int length = this.fieldListFieldIndex.length == index + 1 ? model.field.length + 1 : this.fieldListFieldIndex[index + 1];
            FieldEntry[] fields = new FieldEntry[length -= offset];
            for (int i = 0; i < length; ++i) {
                fields[i] = m.isUnoptimized() ? model.field[fieldPtr.getPointer(offset - 1 + i) - 1] : model.field[offset - 1 + i];
            }
            e.setFields(fields);
        }
        MethodPtrTable methodPtr = (MethodPtrTable)m.getMetadataTable()[5];
        offset = this.methodListMethodIndex[index];
        if (offset > 0 && offset <= model.methodDef.length) {
            int length = this.methodListMethodIndex.length == index + 1 ? model.methodDef.length + 1 : this.methodListMethodIndex[index + 1];
            MethodDefEntry[] methods = new MethodDefEntry[length -= offset];
            for (int i = 0; i < length; ++i) {
                methods[i] = m.isUnoptimized() ? model.methodDef[methodPtr.getPointer(offset - 1 + i) - 1] : model.methodDef[offset - 1 + i];
            }
            e.setMethods(methods);
        }
    }
}

