/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.PropertyEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class PropertyTable
extends AbstractTable {
    public static final int TABLE_INDEX = 23;
    public static final int MIN_ROW_SIZE = 6;
    private int[] propertyAttributeFlags;
    private int[] nameStringIndex;
    private int[] typeBlobIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.propertyAttributeFlags = new int[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.typeBlobIndex = new int[this.rows];
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.propertyAttributeFlags[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readBlobIndex(data, offset, this.typeBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Property Table (23):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  PropertyAttribute Flags: ");
            buffer.append(this.propertyAttributeFlags[i]);
            buffer.append("\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append("\tType BlobIndex: ");
            buffer.append(this.typeBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 23;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        PropertyEntry e = (PropertyEntry)entry[index];
        e.setFlags(this.propertyAttributeFlags[index]);
        e.setName(s.getString(this.nameStringIndex[index]));
        e.setTypeSignature(b.getBlob(this.typeBlobIndex[index]));
    }
}

