/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;

public class PropertyPtrTable
extends AbstractTable {
    public static final int TABLE_INDEX = 22;
    public static final int MIN_ROW_SIZE = 2;
    private int[] propertyIndex;
    private byte sizeOfPropertyIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.propertyIndex = new int[this.rows];
        this.sizeOfPropertyIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 23);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.propertyIndex, row, this.sizeOfPropertyIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 2);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Property Ptr Table (22):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Property Ptr Index: ");
            buffer.append(this.propertyIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 22;
    }

    public int getPointer(int row) {
        return this.propertyIndex == null ? row + 1 : this.propertyIndex[row];
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
    }
}

