/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.PropertyPtrTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.PropertyEntry;
import at.pollaknet.api.facile.metamodel.entries.PropertyMapEntry;

public class PropertyMapTable
extends AbstractTable {
    public static final int TABLE_INDEX = 21;
    public static final int MIN_ROW_SIZE = 4;
    private int[] parentTypeDefIndex;
    private int[] propertyListPropertyIndex;
    private byte sizeOfTypeDefIndex;
    private byte sizeOfPropertyIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.parentTypeDefIndex = new int[this.rows];
        this.propertyListPropertyIndex = new int[this.rows];
        this.sizeOfTypeDefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 2);
        this.sizeOfPropertyIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 23);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.parentTypeDefIndex, row, this.sizeOfTypeDefIndex);
        offset += this.readIndex(data, offset, this.propertyListPropertyIndex, row, this.sizeOfPropertyIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 4);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" PropertyMap Table (21):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Parent Index: ");
            buffer.append(this.parentTypeDefIndex[i]);
            buffer.append("\tPropertyList Index: ");
            buffer.append(this.propertyListPropertyIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 21;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        PropertyMapEntry e = (PropertyMapEntry)entry[index];
        if (this.parentTypeDefIndex[index] > 0) {
            e.setParent(model.typeDef[this.parentTypeDefIndex[index] - 1]);
        }
        PropertyPtrTable propertyPtr = (PropertyPtrTable)m.getMetadataTable()[22];
        int offset = this.propertyListPropertyIndex[index];
        if (offset > 0 && offset <= model.property.length) {
            int length;
            int n = length = this.propertyListPropertyIndex.length == index + 1 ? model.property.length + 1 : this.propertyListPropertyIndex[index + 1];
            if (length > model.property.length + 1) {
                length = model.property.length + 1;
            }
            PropertyEntry[] properties = new PropertyEntry[length -= offset];
            for (int i = 0; i < length; ++i) {
                properties[i] = m.isUnoptimized() ? model.property[propertyPtr.getPointer(offset - 1 + i) - 1] : model.property[offset - 1 + i];
            }
            e.setProperties(properties);
        }
    }
}

