/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.ParamEntry;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.logging.Level;

public class ParamTable
extends AbstractTable {
    public static final int TABLE_INDEX = 8;
    public static final int MIN_ROW_SIZE = 6;
    private int[] paramAttributeFlags;
    private int[] sequence;
    private int[] nameStringIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.paramAttributeFlags = new int[this.rows];
        this.sequence = new int[this.rows];
        this.nameStringIndex = new int[this.rows];
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.paramAttributeFlags[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        if (this.paramAttributeFlags[row] == 53216 || (this.paramAttributeFlags[row] & 0xCFEC) != 0) {
            ParamTable.Log(Level.WARNING, String.format("Param table: Found reserved param attribute flags 0x%x in row %d", this.paramAttributeFlags[row], row));
        }
        this.sequence[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" TypeSpec Table (8):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  ParamAttribute Flags: ");
            buffer.append(this.paramAttributeFlags[i]);
            buffer.append(";\tSequence (constant): ");
            buffer.append(this.sequence[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 8;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        ParamEntry e = (ParamEntry)entry[index];
        e.setFlags(this.paramAttributeFlags[index]);
        e.setSequence(this.sequence[index]);
        e.setName(s.getString(this.nameStringIndex[index]));
    }
}

