/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;

public class ParamPtrTable
extends AbstractTable {
    public static final int TABLE_INDEX = 7;
    public static final int MIN_ROW_SIZE = 2;
    private int[] paramIndex;
    private byte sizeOfParamIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.paramIndex = new int[this.rows];
        this.sizeOfParamIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 8);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.paramIndex, row, this.sizeOfParamIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 2);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Param Ptr Table (7):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Param Ptr Index: ");
            buffer.append(this.paramIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 7;
    }

    public int getPointer(int row) {
        return this.paramIndex == null ? row + 1 : this.paramIndex[row];
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
    }
}

