/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.NestedClassEntry;

public class NestedClassTable
extends AbstractTable {
    public static final int TABLE_INDEX = 41;
    public static final int MIN_ROW_SIZE = 4;
    private int[] nestedClassTypeDefIndex;
    private int[] enclosingClassTypeDefIndex;
    private byte sizeOfTypeDefIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.nestedClassTypeDefIndex = new int[this.rows];
        this.enclosingClassTypeDefIndex = new int[this.rows];
        this.sizeOfTypeDefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 2);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.nestedClassTypeDefIndex, row, this.sizeOfTypeDefIndex);
        offset += this.readIndex(data, offset, this.enclosingClassTypeDefIndex, row, this.sizeOfTypeDefIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 4);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" NestedClass Table (41):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  NestedClass Index: ");
            buffer.append(this.nestedClassTypeDefIndex[i]);
            buffer.append("\tEnclosingClass Index: ");
            buffer.append(this.enclosingClassTypeDefIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 41;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        NestedClassEntry e = (NestedClassEntry)entry[index];
        if (this.nestedClassTypeDefIndex[index] > 0) {
            e.setNestedClass(model.typeDef[this.nestedClassTypeDefIndex[index] - 1]);
        }
        if (this.enclosingClassTypeDefIndex[index] > 0) {
            e.setEnclosingClass(model.typeDef[this.enclosingClassTypeDefIndex[index] - 1]);
        }
    }
}

