/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.ModuleEntry;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModuleTable
extends AbstractTable {
    public static final int TABLE_INDEX = 0;
    public static final int MIN_ROW_SIZE = 10;
    private int[] generation;
    private int[] nameStringIndex;
    private int[] moduleVersionIdGuidIndex;
    private int[] encIdGuidIndex;
    private int[] encBaseIdGuidIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.generation = new int[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.moduleVersionIdGuidIndex = new int[this.rows];
        this.encIdGuidIndex = new int[this.rows];
        this.encBaseIdGuidIndex = new int[this.rows];
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        Logger logger;
        int rowSize = offset;
        if (row != 0) {
            logger = Logger.getLogger("at.pollaknet.api.facile");
            logger.log(Level.WARNING, "module table contains multiple entries!");
        }
        this.generation[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        if (this.generation[row] != 0) {
            logger = Logger.getLogger("at.pollaknet.api.facile");
            logger.log(Level.WARNING, "Unknown value " + this.generation[row] + " in \"generation\" attribute of the module table (reserved, default 0).");
        }
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readGuidIndex(data, offset, this.moduleVersionIdGuidIndex, row);
        offset += this.readGuidIndex(data, offset, this.encIdGuidIndex, row);
        offset += this.readGuidIndex(data, offset, this.encBaseIdGuidIndex, row);
        if (this.encIdGuidIndex[row] != 0) {
            logger = Logger.getLogger("at.pollaknet.api.facile");
            logger.log(Level.WARNING, "Unknown value " + this.encIdGuidIndex[row] + " in \"encIdGuidIndex\" attribute of the module table (reserved, default 0).");
        }
        if (this.encBaseIdGuidIndex[row] != 0) {
            logger = Logger.getLogger("at.pollaknet.api.facile");
            logger.log(Level.WARNING, "Unknown value " + this.encBaseIdGuidIndex[row] + " in \"encIdGuidIndex\" attribute of the module table (reserved, default 0).");
        }
        rowSize = offset - rowSize;
        assert (rowSize >= 10);
        return rowSize;
    }

    @Override
    public String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Module Table (0):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Name Index: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";\tMVID GuidIndex: ");
            buffer.append(this.moduleVersionIdGuidIndex[i]);
            buffer.append(";\tEncId GuidIndex: ");
            buffer.append(this.encIdGuidIndex[i]);
            buffer.append(";\tEncBaseId GuidIndex: ");
            buffer.append(this.encBaseIdGuidIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 0;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        ModuleEntry e = (ModuleEntry)entry[index];
        e.setGeneration(this.generation[index]);
        if (s != null) {
            e.setName(s.getString(this.nameStringIndex[index]));
        } else {
            e.setName(model.getAlternativeModuleName());
        }
        if (g != null) {
            e.setMvId(g.getGuid(this.moduleVersionIdGuidIndex[index]));
            e.setEncId(g.getGuid(this.encIdGuidIndex[index]));
            e.setEncBaseId(g.getGuid(this.encBaseIdGuidIndex[index]));
        }
    }
}

