/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.MethodSpecEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;

public class MethodSpecTable
extends AbstractTable {
    public static final int TABLE_INDEX = 43;
    public static final int MIN_ROW_SIZE = 4;
    private long[] methodCodedIndex;
    private int[] instantiationBlobIndex;
    private byte sizeOfMethodIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.methodCodedIndex = new long[this.rows];
        this.instantiationBlobIndex = new int[this.rows];
        this.sizeOfMethodIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.MethodDefOrRef);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.methodCodedIndex, row, this.sizeOfMethodIndex);
        offset += this.readBlobIndex(data, offset, this.instantiationBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 4);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" MethodSpec Table (43):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Method CodedIndex: ");
            buffer.append(this.methodCodedIndex[i]);
            buffer.append("\tInstantiation BlobIndex: ");
            buffer.append(this.instantiationBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 43;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        MethodSpecEntry e = (MethodSpecEntry)entry[index];
        e.setMethod(EntryDecoder.getMethodDefOrRefEntry(model, this.methodCodedIndex[index]));
        e.setInstantiation(b.getBlob(this.instantiationBlobIndex[index]));
    }
}

