/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.MethodSemanticsEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class MethodSemanticsTable
extends AbstractTable {
    public static final int TABLE_INDEX = 24;
    public static final int MIN_ROW_SIZE = 6;
    private int[] methodSemanticsAttributeFlags;
    private int[] methodMethodDefIndex;
    private long[] associationCodedIndex;
    private byte sizeOfMethodDefIndex;
    private byte sizeOfAssociationIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.methodSemanticsAttributeFlags = new int[this.rows];
        this.methodMethodDefIndex = new int[this.rows];
        this.associationCodedIndex = new long[this.rows];
        this.sizeOfMethodDefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 6);
        this.sizeOfAssociationIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.HasSemantics);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.methodSemanticsAttributeFlags[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        offset += this.readIndex(data, offset, this.methodMethodDefIndex, row, this.sizeOfMethodDefIndex);
        offset += this.readIndex(data, offset, this.associationCodedIndex, row, this.sizeOfAssociationIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" MethodSemantics Table (24):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  MethodSemanticsAttribute Flags: ");
            buffer.append(this.methodSemanticsAttributeFlags[i]);
            buffer.append("\tMethod Index: ");
            buffer.append(this.methodMethodDefIndex[i]);
            buffer.append("\tAssociation CodedIndex: ");
            buffer.append(this.associationCodedIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 24;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        MethodSemanticsEntry e = (MethodSemanticsEntry)entry[index];
        e.setSemantics(this.methodSemanticsAttributeFlags[index]);
        if (this.methodMethodDefIndex[index] > 0) {
            e.setMethod(model.methodDef[this.methodMethodDefIndex[index] - 1]);
        }
        e.setAssociation(EntryDecoder.getHasSemanticsEntry(model, this.associationCodedIndex[index]));
    }
}

