/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;

public class MethodPtrTable
extends AbstractTable {
    public static final int TABLE_INDEX = 5;
    public static final int MIN_ROW_SIZE = 2;
    private int[] methodIndex;
    private byte sizeOfMethodIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.methodIndex = new int[this.rows];
        this.sizeOfMethodIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 6);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.methodIndex, row, this.sizeOfMethodIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 2);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Method Ptr Table (5):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Method Ptr Index: ");
            buffer.append(this.methodIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 5;
    }

    public int getPointer(int row) {
        return this.methodIndex == null ? row + 1 : this.methodIndex[row];
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
    }
}

