/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.MethodImplEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;

public class MethodImplTable
extends AbstractTable {
    public static final int TABLE_INDEX = 25;
    public static final int MIN_ROW_SIZE = 6;
    private int[] classTypeDefIndex;
    private long[] methodBodyCodedIndex;
    private long[] methodDeclarationCodedIndex;
    private byte sizeOfTypeDefIndex;
    private byte sizeOfMethodBodyDeclIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.classTypeDefIndex = new int[this.rows];
        this.methodBodyCodedIndex = new long[this.rows];
        this.methodDeclarationCodedIndex = new long[this.rows];
        this.sizeOfTypeDefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 2);
        this.sizeOfMethodBodyDeclIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.MethodDefOrRef);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.classTypeDefIndex, row, this.sizeOfTypeDefIndex);
        offset += this.readIndex(data, offset, this.methodBodyCodedIndex, row, this.sizeOfMethodBodyDeclIndex);
        offset += this.readIndex(data, offset, this.methodDeclarationCodedIndex, row, this.sizeOfMethodBodyDeclIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" MethodImpl Table (25):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Class Index: ");
            buffer.append(this.classTypeDefIndex[i]);
            buffer.append("\tMethodBody CodedIndex: ");
            buffer.append(this.methodBodyCodedIndex[i]);
            buffer.append("\tMethodDeclaration CodedIndex: ");
            buffer.append(this.methodDeclarationCodedIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 25;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        MethodImplEntry e = (MethodImplEntry)entry[index];
        if (this.classTypeDefIndex[index] > 0) {
            e.setOwnerClass(model.typeDef[this.classTypeDefIndex[index] - 1]);
        }
        e.setImplementationBody(EntryDecoder.getMethodDefOrRefEntry(model, this.methodBodyCodedIndex[index]));
        e.setMethodDeclaration(EntryDecoder.getMethodDefOrRefEntry(model, this.methodDeclarationCodedIndex[index]));
    }
}

