/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ParamPtrTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.ParamEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class MethodDefTable
extends AbstractTable {
    public static final int TABLE_INDEX = 6;
    public static final int MIN_ROW_SIZE = 14;
    private long[] relativeVirtualAddress;
    private int[] methodImplAttributeFlags;
    private int[] methodAttributeFlags;
    private int[] nameStringIndex;
    private int[] signatureBlobIndex;
    private int[] paramListParamIndex;
    private byte sizeOfParamIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.relativeVirtualAddress = new long[this.rows];
        this.methodImplAttributeFlags = new int[this.rows];
        this.methodAttributeFlags = new int[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.signatureBlobIndex = new int[this.rows];
        this.paramListParamIndex = new int[this.rows];
        this.sizeOfParamIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 8);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.relativeVirtualAddress[row] = ByteReader.getUInt32(data, offset);
        this.methodImplAttributeFlags[row] = ByteReader.getUInt16(data, offset += 4);
        this.methodAttributeFlags[row] = ByteReader.getUInt16(data, offset += 2);
        offset += 2;
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readBlobIndex(data, offset, this.signatureBlobIndex, row);
        offset += this.readIndex(data, offset, this.paramListParamIndex, row, this.sizeOfParamIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 14);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" MethodDef Table (6):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  RelativeVirtualAddress: ");
            buffer.append(this.relativeVirtualAddress[i]);
            buffer.append(";\tImplAttribute Flags: ");
            buffer.append(this.methodImplAttributeFlags[i]);
            buffer.append(";\tAttribute Flags: ");
            buffer.append(this.methodAttributeFlags[i]);
            buffer.append("\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";\tSignature BlobIndex: ");
            buffer.append(this.signatureBlobIndex[i]);
            buffer.append(";\tParamList Index: ");
            buffer.append(this.paramListParamIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 6;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        MethodDefEntry e = (MethodDefEntry)entry[index];
        e.setRelativeVirtualAddress(this.relativeVirtualAddress[index]);
        e.setImplFlags(this.methodImplAttributeFlags[index]);
        e.setFlags(this.methodAttributeFlags[index]);
        e.setName(s.getString(this.nameStringIndex[index]));
        e.setSignature(b.getBlob(this.signatureBlobIndex[index]));
        ParamPtrTable paramPtr = (ParamPtrTable)m.getMetadataTable()[7];
        int offset = this.paramListParamIndex[index];
        if (offset > 0 && offset <= model.param.length) {
            int length = this.paramListParamIndex.length == index + 1 ? model.param.length + 1 : this.paramListParamIndex[index + 1];
            ParamEntry[] params = new ParamEntry[length -= offset];
            for (int i = 0; i < length; ++i) {
                params[i] = m.isUnoptimized() && paramPtr != null ? model.param[paramPtr.getPointer(offset - 1 + i) - 1] : model.param[offset - 1 + i];
            }
            e.setParams(params);
        }
    }
}

