/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.MemberRefEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;

public class MemberRefTable
extends AbstractTable {
    public static final int TABLE_INDEX = 10;
    public static final int MIN_ROW_SIZE = 6;
    private long[] classCodedIndex;
    private int[] nameStringIndex;
    private int[] signatureBlobIndex;
    private byte sizeOfClassIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.classCodedIndex = new long[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.signatureBlobIndex = new int[this.rows];
        this.sizeOfClassIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.MemberRefParent);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.classCodedIndex, row, this.sizeOfClassIndex);
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readBlobIndex(data, offset, this.signatureBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" MemberRef Table (10):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Class CodedIndex: ");
            buffer.append(this.classCodedIndex[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";\tSignature BlobIndex: ");
            buffer.append(this.signatureBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 10;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        MemberRefEntry e = (MemberRefEntry)entry[index];
        e.setOwnerClass(EntryDecoder.getMemberRefParentEntry(model, this.classCodedIndex[index]));
        e.setName(s.getString(this.nameStringIndex[index]));
        e.setBinarySignature(b.getBlob(this.signatureBlobIndex[index]));
    }
}

