/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.ManifestResourceEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class ManifestResourceTable
extends AbstractTable {
    public static final int TABLE_INDEX = 40;
    public static final int MIN_ROW_SIZE = 12;
    private long[] manifestOffset;
    private long[] resourceAttributeFlags;
    private int[] nameStringIndex;
    private long[] implementationCodedIndex;
    private byte sizeOfImplementationIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.manifestOffset = new long[this.rows];
        this.resourceAttributeFlags = new long[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.implementationCodedIndex = new long[this.rows];
        this.sizeOfImplementationIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.Implementation);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.manifestOffset[row] = ByteReader.getUInt32(data, offset);
        this.resourceAttributeFlags[row] = ByteReader.getUInt32(data, offset += 4);
        offset += 4;
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readIndex(data, offset, this.implementationCodedIndex, row, this.sizeOfImplementationIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 12);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" ManifestResource Table (40):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Offset: ");
            buffer.append(this.manifestOffset[i]);
            buffer.append(";\tResourceAttribute Flags: ");
            buffer.append(this.resourceAttributeFlags[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";\tImpl CodedIndex: ");
            buffer.append(this.implementationCodedIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 40;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        ManifestResourceEntry e = (ManifestResourceEntry)entry[index];
        e.setOffset(this.manifestOffset[index]);
        e.setFlags(this.resourceAttributeFlags[index]);
        if (s == null) {
            e.setName(model.getAlternativeModuleName());
        } else {
            e.setName(s.getString(this.nameStringIndex[index]));
        }
        e.setImplementation(EntryDecoder.getImplementationEntry(model, this.implementationCodedIndex[index]));
    }
}

