/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.InterfaceImplEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;

public class InterfaceImplTable
extends AbstractTable {
    public static final int TABLE_INDEX = 9;
    public static final int MIN_ROW_SIZE = 4;
    private int[] classTypeDefIndex;
    private int[] interfaceCodedIndex;
    private byte sizeOfTypeDefIndex;
    private byte sizeOfInterfaceIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.classTypeDefIndex = new int[this.rows];
        this.interfaceCodedIndex = new int[this.rows];
        this.sizeOfTypeDefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 2);
        this.sizeOfInterfaceIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.TypeDefOrRef);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.classTypeDefIndex, row, this.sizeOfTypeDefIndex);
        offset += this.readIndex(data, offset, this.interfaceCodedIndex, row, this.sizeOfInterfaceIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 4);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" InterfaceImpl Table (9):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Class Index: ");
            buffer.append(this.classTypeDefIndex[i]);
            buffer.append(";\tInterface CodedIndex: ");
            buffer.append(this.interfaceCodedIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 9;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        InterfaceImplEntry e = (InterfaceImplEntry)entry[index];
        if (this.classTypeDefIndex[index] > 0) {
            e.setImplementationClass(model.typeDef[this.classTypeDefIndex[index] - 1]);
        }
        e.setInterface(EntryDecoder.getTypeDefOrRefEntry(model, this.interfaceCodedIndex[index]));
    }
}

