/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.ImplMapEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class ImplMapTable
extends AbstractTable {
    public static final int TABLE_INDEX = 28;
    public static final int MIN_ROW_SIZE = 8;
    private int[] pInvokeAttributeFlags;
    private long[] memberForwardedCodedIndex;
    private int[] importNameStringIndex;
    private int[] importScopeModuleRefIndex;
    private byte sizeOfMemberForwardedIndex;
    private byte sizeOfModuleRefIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.pInvokeAttributeFlags = new int[this.rows];
        this.memberForwardedCodedIndex = new long[this.rows];
        this.importNameStringIndex = new int[this.rows];
        this.importScopeModuleRefIndex = new int[this.rows];
        this.sizeOfModuleRefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 26);
        this.sizeOfMemberForwardedIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.MemberForwarded);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.pInvokeAttributeFlags[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        offset += this.readIndex(data, offset, this.memberForwardedCodedIndex, row, this.sizeOfMemberForwardedIndex);
        offset += this.readStringIndex(data, offset, this.importNameStringIndex, row);
        offset += this.readIndex(data, offset, this.importScopeModuleRefIndex, row, this.sizeOfModuleRefIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 8);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" ImplMap Table (28):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  PInvokeAttribute Flags: ");
            buffer.append(this.pInvokeAttributeFlags[i]);
            buffer.append(";\tMemberForwarded CodedIndex: ");
            buffer.append(this.memberForwardedCodedIndex[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.importNameStringIndex[i]);
            buffer.append(";\tImportScope Index: ");
            buffer.append(this.importScopeModuleRefIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 28;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        ImplMapEntry e = (ImplMapEntry)entry[index];
        e.setMappingFlags(this.pInvokeAttributeFlags[index]);
        e.setMemberForwarded(EntryDecoder.getMemberForwardedEntry(model, this.memberForwardedCodedIndex[index]));
        e.setImportName(s.getString(this.importNameStringIndex[index]));
        if (this.importScopeModuleRefIndex[index] > 0) {
            e.setImportScope(model.moduleRef[this.importScopeModuleRefIndex[index] - 1]);
        }
    }
}

