/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.GenericParamEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class GenericParamTable
extends AbstractTable {
    public static final int TABLE_INDEX = 42;
    public static final int MIN_ROW_SIZE = 8;
    private int[] number;
    private int[] paramAttributeFlags;
    private int[] ownerCodedIndex;
    private int[] nameStringIndex;
    private int[] methodCodedIndex;
    private byte sizeOfOwnerIndex;
    private byte sizeOfMethodIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.number = new int[this.rows];
        this.paramAttributeFlags = new int[this.rows];
        this.ownerCodedIndex = new int[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.methodCodedIndex = new int[this.rows];
        this.sizeOfOwnerIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.TypeOrMethodDef);
        this.sizeOfMethodIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.TypeDefOrRef);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.number[row] = ByteReader.getUInt16(data, offset);
        this.paramAttributeFlags[row] = ByteReader.getUInt16(data, offset += 2);
        offset += 2;
        offset += this.readIndex(data, offset, this.ownerCodedIndex, row, this.sizeOfOwnerIndex);
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        if (this.isVersion_1_1_MetadataStream) {
            offset += this.readIndex(data, offset, this.methodCodedIndex, row, this.sizeOfMethodIndex);
        }
        rowSize = offset - rowSize;
        assert (rowSize >= 8);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" GenericParam Table (42):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Number: ");
            buffer.append(this.number[i]);
            buffer.append(";\tParamAttribute Flags: ");
            buffer.append(this.paramAttributeFlags[i]);
            buffer.append(";\tOwner CodedIndex: ");
            buffer.append(this.ownerCodedIndex[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 42;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        GenericParamEntry e = (GenericParamEntry)entry[index];
        e.setNumber(this.number[index]);
        e.setFlags(this.paramAttributeFlags[index]);
        e.setOwner(EntryDecoder.getTypeOrMethodDefEntry(model, this.ownerCodedIndex[index]));
        e.setName(s.getString(this.nameStringIndex[index]));
        if (this.isVersion_1_1_MetadataStream) {
            e.setMethod(EntryDecoder.getTypeOrMethodDefEntry(model, this.methodCodedIndex[index]));
        }
    }
}

