/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.GenericParamConstraintEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;

public class GenericParamConstraintTable
extends AbstractTable {
    public static final int TABLE_INDEX = 44;
    public static final int MIN_ROW_SIZE = 4;
    private int[] ownerGenericParamIndex;
    private long[] constraintCodedIndex;
    private byte sizeOfOwnerIndex;
    private byte sizeOfConstraintIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.ownerGenericParamIndex = new int[this.rows];
        this.constraintCodedIndex = new long[this.rows];
        this.sizeOfOwnerIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 42);
        this.sizeOfConstraintIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.TypeDefOrRef);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.ownerGenericParamIndex, row, this.sizeOfOwnerIndex);
        offset += this.readIndex(data, offset, this.constraintCodedIndex, row, this.sizeOfConstraintIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 4);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" GenericParamConstraint Table (44):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Owner Index: ");
            buffer.append(this.ownerGenericParamIndex[i]);
            buffer.append(";\tConstraint CodedIndex: ");
            buffer.append(this.constraintCodedIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 44;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        GenericParamConstraintEntry e = (GenericParamConstraintEntry)entry[index];
        if (this.ownerGenericParamIndex[index] > 0) {
            e.setOwner(model.genericParam[this.ownerGenericParamIndex[index] - 1]);
        }
        e.setConstraint(EntryDecoder.getTypeDefOrRefEntry(model, this.constraintCodedIndex[index]));
    }
}

