/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.FileEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class FileTable
extends AbstractTable {
    public static final int TABLE_INDEX = 38;
    public static final int MIN_ROW_SIZE = 8;
    private long[] fileAttributeFlags;
    private int[] nameStringIndex;
    private int[] hashValueBlobIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.fileAttributeFlags = new long[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.hashValueBlobIndex = new int[this.rows];
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.fileAttributeFlags[row] = ByteReader.getUInt32(data, offset);
        offset += 4;
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readBlobIndex(data, offset, this.hashValueBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 8);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" File Table (38):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  FileAttribute Flags: ");
            buffer.append(this.fileAttributeFlags[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";\tHashValue BlobIndex: ");
            buffer.append(this.hashValueBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 38;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        FileEntry e = (FileEntry)entry[index];
        e.setFlags(this.fileAttributeFlags[index]);
        e.setName(s.getString(this.nameStringIndex[index]));
        e.setHashValue(b.getBlob(this.hashValueBlobIndex[index]));
    }
}

