/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.FieldEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class FieldTable
extends AbstractTable {
    public static final int TABLE_INDEX = 4;
    public static final int MIN_ROW_SIZE = 6;
    private int[] fieldAttributesFlags;
    private int[] nameStringIndex;
    private int[] signatureBlobIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.fieldAttributesFlags = new int[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.signatureBlobIndex = new int[this.rows];
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.fieldAttributesFlags[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        assert ((this.fieldAttributesFlags[row] & 0x4800) == 0);
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readBlobIndex(data, offset, this.signatureBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Field Table (4):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  FieldAttributes Flags: ");
            buffer.append(this.fieldAttributesFlags[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";\tSignature BlobIndex: ");
            buffer.append(this.signatureBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 4;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        FieldEntry e = (FieldEntry)entry[index];
        e.setFlags(this.fieldAttributesFlags[index]);
        String fieldName = s.getString(this.nameStringIndex[index]);
        if (fieldName != null) {
            if (fieldName.endsWith(">k__BackingField")) {
                e.setName("'" + fieldName + "'");
            } else {
                e.setName(fieldName);
            }
        }
        e.setBinarySignature(b.getBlob(this.signatureBlobIndex[index]));
    }
}

