/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.FieldRVAEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class FieldRVATable
extends AbstractTable {
    public static final int TABLE_INDEX = 29;
    public static final int MIN_ROW_SIZE = 6;
    private long[] relativeVirtualAddress;
    private int[] fieldFieldIndex;
    private byte sizeOfFieldIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.relativeVirtualAddress = new long[this.rows];
        this.fieldFieldIndex = new int[this.rows];
        this.sizeOfFieldIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 4);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.relativeVirtualAddress[row] = ByteReader.getUInt32(data, offset);
        offset += 4;
        offset += this.readIndex(data, offset, this.fieldFieldIndex, row, this.sizeOfFieldIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" FieldRVA Table (29):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  RelativeVirtualAddress: ");
            buffer.append(this.relativeVirtualAddress[i]);
            buffer.append(";\tField Index: ");
            buffer.append(this.fieldFieldIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 29;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        FieldRVAEntry e = (FieldRVAEntry)entry[index];
        e.setRelativeVirtualAddress(this.relativeVirtualAddress[index]);
        if (this.fieldFieldIndex[index] > 0) {
            e.setField(model.field[this.fieldFieldIndex[index] - 1]);
        }
    }
}

