/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.FieldLayoutEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class FieldLayoutTable
extends AbstractTable {
    public static final int TABLE_INDEX = 16;
    public static final int MIN_ROW_SIZE = 6;
    private long[] offset;
    private int[] fieldFieldIndex;
    private byte sizeOfFieldIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.offset = new long[this.rows];
        this.fieldFieldIndex = new int[this.rows];
        this.sizeOfFieldIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 4);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.offset[row] = ByteReader.getUInt32(data, offset);
        offset += 4;
        offset += this.readIndex(data, offset, this.fieldFieldIndex, row, this.sizeOfFieldIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" FieldLayout Table (16):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Offset: ");
            buffer.append(this.offset[i]);
            buffer.append("\tField Index: ");
            buffer.append(this.fieldFieldIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 16;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        FieldLayoutEntry e = (FieldLayoutEntry)entry[index];
        e.setOffset(this.offset[index]);
        if (this.fieldFieldIndex[index] > 0) {
            e.setField(model.field[this.fieldFieldIndex[index] - 1]);
        }
    }
}

