/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.ExportedTypeEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class ExportedTypeTable
extends AbstractTable {
    public static final int TABLE_INDEX = 39;
    public static final int MIN_ROW_SIZE = 14;
    private long[] typeAttributesFlags;
    private int[] typeDefId;
    private int[] typeNameStringIndex;
    private int[] typeNamespaceStringIndex;
    private long[] implementationCodedIndex;
    private byte sizeOfImplementationIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.typeAttributesFlags = new long[this.rows];
        this.typeDefId = new int[this.rows];
        this.typeNameStringIndex = new int[this.rows];
        this.typeNamespaceStringIndex = new int[this.rows];
        this.implementationCodedIndex = new long[this.rows];
        this.sizeOfImplementationIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.Implementation);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.typeAttributesFlags[row] = ByteReader.getUInt32(data, offset);
        long value = ByteReader.getUInt32(data, offset += 4);
        offset += 4;
        assert (value < Integer.MAX_VALUE);
        this.typeDefId[row] = (int)value;
        offset += this.readStringIndex(data, offset, this.typeNameStringIndex, row);
        offset += this.readStringIndex(data, offset, this.typeNamespaceStringIndex, row);
        offset += this.readIndex(data, offset, this.implementationCodedIndex, row, this.sizeOfImplementationIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 14);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" ExportedType Table (39):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  TypeAttributes Flags: ");
            buffer.append(this.typeAttributesFlags[i]);
            buffer.append(";\tTypeDefId: ");
            buffer.append(this.typeDefId[i]);
            buffer.append(";\tTypeName StringIndex: ");
            buffer.append(this.typeNameStringIndex[i]);
            buffer.append(";\tTypeNamespace StringIndex: ");
            buffer.append(this.typeNamespaceStringIndex[i]);
            buffer.append(";\tImpl CodedIndex: ");
            buffer.append(this.implementationCodedIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 39;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        ExportedTypeEntry e = (ExportedTypeEntry)entry[index];
        e.setFlags(this.typeAttributesFlags[index]);
        e.setTypeDefId(this.typeDefId[index]);
        e.setName(s.getString(this.typeNameStringIndex[index]));
        e.setNamespace(s.getString(this.typeNamespaceStringIndex[index]));
        e.setImplementation(EntryDecoder.getImplementationEntry(model, this.implementationCodedIndex[index]));
    }
}

