/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.EventEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class EventTable
extends AbstractTable {
    public static final int TABLE_INDEX = 20;
    public static final int MIN_ROW_SIZE = 6;
    private int[] eventAttributesFlags;
    private int[] nameStringIndex;
    private long[] eventTypeCodedIndex;
    private byte sizeOfEventTypeIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.eventAttributesFlags = new int[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.eventTypeCodedIndex = new long[this.rows];
        this.sizeOfEventTypeIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.TypeDefOrRef);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.eventAttributesFlags[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        assert ((this.eventAttributesFlags[row] & 0xF9FF) == 0);
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readIndex(data, offset, this.eventTypeCodedIndex, row, this.sizeOfEventTypeIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Event Table (20):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  EventAttributes Flags: ");
            buffer.append(this.eventAttributesFlags[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";\tEventType CodedIndex: ");
            buffer.append(this.eventTypeCodedIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 20;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        EventEntry e = (EventEntry)entry[index];
        e.setEventFlags(this.eventAttributesFlags[index]);
        e.setName(s.getString(this.nameStringIndex[index]));
        e.setEventType(EntryDecoder.getTypeDefOrRefEntry(model, this.eventTypeCodedIndex[index]));
    }
}

