/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;

public class EventPtrTable
extends AbstractTable {
    public static final int TABLE_INDEX = 19;
    public static final int MIN_ROW_SIZE = 2;
    private int[] eventIndex;
    private byte sizeOfEventIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.eventIndex = new int[this.rows];
        this.sizeOfEventIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 20);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.eventIndex, row, this.sizeOfEventIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 2);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Event Ptr Table (19):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Event Ptr Index: ");
            buffer.append(this.eventIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 19;
    }

    public int getPointer(int row) {
        return this.eventIndex == null ? row + 1 : this.eventIndex[row];
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
    }
}

