/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.EventPtrTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.EventEntry;
import at.pollaknet.api.facile.metamodel.entries.EventMapEntry;

public class EventMapTable
extends AbstractTable {
    public static final int TABLE_INDEX = 18;
    public static final int MIN_ROW_SIZE = 4;
    private int[] parentTypeDefIndex;
    private int[] eventListEventIndex;
    private byte sizeOfTypeDefIndex;
    private byte sizeOfEventIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.parentTypeDefIndex = new int[this.rows];
        this.eventListEventIndex = new int[this.rows];
        this.sizeOfTypeDefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 2);
        this.sizeOfEventIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 20);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.parentTypeDefIndex, row, this.sizeOfTypeDefIndex);
        offset += this.readIndex(data, offset, this.eventListEventIndex, row, this.sizeOfEventIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 4);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" EventMap Table (18):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Parent Index: ");
            buffer.append(this.parentTypeDefIndex[i]);
            buffer.append("\tEventList Index: ");
            buffer.append(this.eventListEventIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 18;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        EventMapEntry e = (EventMapEntry)entry[index];
        if (this.parentTypeDefIndex[index] > 0) {
            e.setParent(model.typeDef[this.parentTypeDefIndex[index] - 1]);
        }
        EventPtrTable eventPtr = (EventPtrTable)m.getMetadataTable()[19];
        int offset = this.eventListEventIndex[index];
        if (offset > 0 && offset <= model.event.length) {
            int length = this.eventListEventIndex.length == index + 1 ? model.event.length + 1 : this.eventListEventIndex[index + 1];
            EventEntry[] events = new EventEntry[length -= offset];
            for (int i = 0; i < length; ++i) {
                events[i] = m.isUnoptimized() ? model.event[eventPtr.getPointer(offset - 1 + i) - 1] : model.event[offset - 1 + i];
            }
            e.setEvents(events);
        }
    }
}

