/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.DeclSecurityEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class DeclSecurityTable
extends AbstractTable {
    public static final int TABLE_INDEX = 14;
    public static final int MIN_ROW_SIZE = 6;
    private int[] action;
    private long[] parentCodedIndex;
    private int[] permissionSetBlobIndex;
    private byte parentIndexSize;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.action = new int[this.rows];
        this.parentCodedIndex = new long[this.rows];
        this.permissionSetBlobIndex = new int[this.rows];
        this.parentIndexSize = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.HasDeclSecurity);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.action[row] = ByteReader.getUInt16(data, offset);
        offset += 2;
        offset += this.readIndex(data, offset, this.parentCodedIndex, row, this.parentIndexSize);
        offset += this.readBlobIndex(data, offset, this.permissionSetBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" DeclSecurity Table (14):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Action: ");
            buffer.append(this.action[i]);
            buffer.append("\tParent CodedIndex: ");
            buffer.append(this.parentCodedIndex[i]);
            buffer.append(";\tPermissionSet BlobIndex: ");
            buffer.append(this.permissionSetBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 14;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        DeclSecurityEntry e = (DeclSecurityEntry)entry[index];
        e.setAction(this.action[index]);
        e.setParent(EntryDecoder.getHasDeclSecurityEntry(model, this.parentCodedIndex[index]));
        e.setPermissionSet(b.getBlob(this.permissionSetBlobIndex[index]));
        e.setBinaryBlobIndex(this.permissionSetBlobIndex[index]);
    }
}

