/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.CustomAttributeEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;

public class CustomAttributeTable
extends AbstractTable {
    public static final int TABLE_INDEX = 12;
    public static final int MIN_ROW_SIZE = 6;
    private long[] parentCodedIndex;
    private int[] typeCodedIndex;
    private int[] valueBlobIndex;
    private byte parentIndexSize;
    private byte typeIndexSize;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.parentCodedIndex = new long[this.rows];
        this.typeCodedIndex = new int[this.rows];
        this.valueBlobIndex = new int[this.rows];
        this.parentIndexSize = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.HasCustomAttribute);
        this.typeIndexSize = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.CustomAttributeType);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.parentCodedIndex, row, this.parentIndexSize);
        offset += this.readIndex(data, offset, this.typeCodedIndex, row, this.typeIndexSize);
        offset += this.readBlobIndex(data, offset, this.valueBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" CustomAttribute Table (12):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Parent CodedIndex: ");
            buffer.append(this.parentCodedIndex[i]);
            buffer.append(";\tType CodedIndex: ");
            buffer.append(this.typeCodedIndex[i]);
            buffer.append(";\tValue BlobIndex: ");
            buffer.append(this.valueBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 12;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        CustomAttributeEntry e = (CustomAttributeEntry)entry[index];
        e.setOwner(EntryDecoder.getHasCustomAttributeEntry(model, this.parentCodedIndex[index]));
        e.setCustomAttributeType(EntryDecoder.getCustomAttributeTypeEntry(model, this.typeCodedIndex[index]));
        e.setValue(b.getBlob(this.valueBlobIndex[index]));
        e.setBinaryBlobIndex(this.valueBlobIndex[index]);
    }
}

