/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.ConstantEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;
import at.pollaknet.api.facile.util.ByteReader;

public class ConstantTable
extends AbstractTable {
    public static final int TABLE_INDEX = 11;
    public static final int MIN_ROW_SIZE = 6;
    private int[] type;
    private long[] parentCodedIndex;
    private int[] valueBlobIndex;
    private byte parentIndexSize;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.type = new int[this.rows];
        this.parentCodedIndex = new long[this.rows];
        this.valueBlobIndex = new int[this.rows];
        this.parentIndexSize = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.HasConstant);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.type[row] = ByteReader.getUInt8(data, offset);
        assert (ByteReader.getUInt8(data, (offset += 2) - 1) == 0);
        offset += this.readIndex(data, offset, this.parentCodedIndex, row, this.parentIndexSize);
        offset += this.readBlobIndex(data, offset, this.valueBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" Constant Table (11):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Type: ");
            buffer.append(this.type[i]);
            buffer.append(";\tParent CodedIndex: ");
            buffer.append(this.parentCodedIndex[i]);
            buffer.append(";\tValue BlobIndex: ");
            buffer.append(this.valueBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 11;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        ConstantEntry e = (ConstantEntry)entry[index];
        e.setType(this.type[index]);
        e.setParent(EntryDecoder.getHasConstantEntry(model, this.parentCodedIndex[index]));
        e.setValue(b.getBlob(this.valueBlobIndex[index]));
    }
}

