/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.ClassLayoutEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class ClassLayoutTable
extends AbstractTable {
    public static final int TABLE_INDEX = 15;
    public static final int MIN_ROW_SIZE = 8;
    private int[] packingSize;
    private long[] classSize;
    private int[] parentTypeDefIndex;
    private byte parentIndexSize;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.packingSize = new int[this.rows];
        this.classSize = new long[this.rows];
        this.parentTypeDefIndex = new int[this.rows];
        this.parentIndexSize = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 2);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.packingSize[row] = ByteReader.getUInt16(data, offset);
        this.classSize[row] = ByteReader.getUInt32(data, offset += 2);
        offset += 4;
        offset += this.readIndex(data, offset, this.parentTypeDefIndex, row, this.parentIndexSize);
        rowSize = offset - rowSize;
        assert (rowSize >= 8);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" ClassLayout Table (15):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  PackingSize: ");
            buffer.append(this.packingSize[i]);
            buffer.append("\tClassSize: ");
            buffer.append(this.classSize[i]);
            buffer.append(";\tParent Index: ");
            buffer.append(this.parentTypeDefIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 15;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        ClassLayoutEntry e = (ClassLayoutEntry)entry[index];
        e.setPackingSize(this.packingSize[index]);
        e.setClassSize(this.classSize[index]);
        if (this.parentTypeDefIndex[index] > 0) {
            e.setParent(model.typeDef[this.parentTypeDefIndex[index] - 1]);
        }
    }
}

