/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.AssemblyRefEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class AssemblyRefTable
extends AbstractTable {
    public static final int TABLE_INDEX = 35;
    public static final int MIN_ROW_SIZE = 20;
    private int[] majorVersion;
    private int[] minorVersion;
    private int[] buildNumber;
    private int[] revisionNumber;
    private long[] assemblyFlags;
    private int[] publicKeyBlobIndex;
    private int[] nameStringIndex;
    private int[] cultureStringIndex;
    private int[] hashValueBlobIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.majorVersion = new int[this.rows];
        this.minorVersion = new int[this.rows];
        this.buildNumber = new int[this.rows];
        this.revisionNumber = new int[this.rows];
        this.assemblyFlags = new long[this.rows];
        this.publicKeyBlobIndex = new int[this.rows];
        this.nameStringIndex = new int[this.rows];
        this.cultureStringIndex = new int[this.rows];
        this.hashValueBlobIndex = new int[this.rows];
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.majorVersion[row] = ByteReader.getUInt16(data, offset);
        this.minorVersion[row] = ByteReader.getUInt16(data, offset += 2);
        this.buildNumber[row] = ByteReader.getUInt16(data, offset += 2);
        this.revisionNumber[row] = ByteReader.getUInt16(data, offset += 2);
        this.assemblyFlags[row] = ByteReader.getUInt32(data, offset += 2);
        offset += 4;
        offset += this.readBlobIndex(data, offset, this.publicKeyBlobIndex, row);
        offset += this.readStringIndex(data, offset, this.nameStringIndex, row);
        offset += this.readStringIndex(data, offset, this.cultureStringIndex, row);
        offset += this.readBlobIndex(data, offset, this.hashValueBlobIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 20);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" AssemblyRef Table (35):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  MajorVersion: ");
            buffer.append(this.majorVersion[i]);
            buffer.append(";\tMinorVersion: ");
            buffer.append(this.minorVersion[i]);
            buffer.append("\tBuildNumber: ");
            buffer.append(this.buildNumber[i]);
            buffer.append(";\tRevisionNumber: ");
            buffer.append(this.revisionNumber[i]);
            buffer.append(";\tAssemblyFlags: ");
            buffer.append(this.assemblyFlags[i]);
            buffer.append("\tPublicKey BlobIndex: ");
            buffer.append(this.publicKeyBlobIndex[i]);
            buffer.append(";\tName StringIndex: ");
            buffer.append(this.nameStringIndex[i]);
            buffer.append(";\tCulture StringIndex: ");
            buffer.append(this.cultureStringIndex[i]);
            buffer.append(";\tHashValue BlobIndex: ");
            buffer.append(this.hashValueBlobIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 35;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        AssemblyRefEntry e = (AssemblyRefEntry)entry[index];
        e.setMajorVersion(this.majorVersion[index]);
        e.setMinorVersion(this.minorVersion[index]);
        e.setBuildNumber(this.buildNumber[index]);
        e.setRevisionNumber(this.revisionNumber[index]);
        e.setFlags(this.assemblyFlags[index]);
        e.setPublicKey(b.getBlob(this.publicKeyBlobIndex[index]));
        e.setName(s.getString(this.nameStringIndex[index]));
        e.setCulture(s.getString(this.cultureStringIndex[index]));
        e.setHashValue(b.getBlob(this.hashValueBlobIndex[index]));
    }
}

