/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.AssemblyRefProcessorEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class AssemblyRefProcessorTable
extends AbstractTable {
    public static final int TABLE_INDEX = 36;
    public static final int MIN_ROW_SIZE = 6;
    private long[] processor;
    private int[] assemblyRefAssemblyRefIndex;
    private byte sizeOfAssemblyRefIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.processor = new long[this.rows];
        this.assemblyRefAssemblyRefIndex = new int[this.rows];
        this.sizeOfAssemblyRefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 35);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.processor[row] = ByteReader.getUInt32(data, offset);
        offset += 4;
        offset += this.readIndex(data, offset, this.assemblyRefAssemblyRefIndex, row, this.sizeOfAssemblyRefIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" AssemblyRefProcessor Table (36):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Processor: ");
            buffer.append(this.processor[i]);
            buffer.append(";\tAssemblyRef Index: ");
            buffer.append(this.assemblyRefAssemblyRefIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 36;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        AssemblyRefProcessorEntry e = (AssemblyRefProcessorEntry)entry[index];
        e.setProcessor(this.processor[index]);
        if (this.assemblyRefAssemblyRefIndex[index] > 0) {
            e.setAssemblyRef(model.assemblyRef[this.assemblyRefAssemblyRefIndex[index] - 1]);
        }
    }
}

