/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.AssemblyRefOsEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class AssemblyRefOsTable
extends AbstractTable {
    public static final int TABLE_INDEX = 37;
    public static final int MIN_ROW_SIZE = 14;
    private long[] platformID;
    private long[] majorVersion;
    private long[] minorVersion;
    private int[] assemblyRefAssemblyRefIndex;
    private byte sizeOfAssemblyRefIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.platformID = new long[this.rows];
        this.majorVersion = new long[this.rows];
        this.minorVersion = new long[this.rows];
        this.assemblyRefAssemblyRefIndex = new int[this.rows];
        this.sizeOfAssemblyRefIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 35);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.platformID[row] = ByteReader.getUInt32(data, offset);
        this.majorVersion[row] = ByteReader.getUInt32(data, offset += 4);
        this.minorVersion[row] = ByteReader.getUInt32(data, offset += 4);
        offset += 4;
        offset += this.readIndex(data, offset, this.assemblyRefAssemblyRefIndex, row, this.sizeOfAssemblyRefIndex);
        rowSize = offset - rowSize;
        assert (rowSize >= 14);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" AssemblyRefOS Table (37):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Platform ID: ");
            buffer.append(this.platformID[i]);
            buffer.append("\tMajorVersion: ");
            buffer.append(this.majorVersion[i]);
            buffer.append("\tMinorVersion: ");
            buffer.append(this.minorVersion[i]);
            buffer.append("\tAssemblyRef Index: ");
            buffer.append(this.assemblyRefAssemblyRefIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 37;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        AssemblyRefOsEntry e = (AssemblyRefOsEntry)entry[index];
        e.setOsPlatformId(this.platformID[index]);
        e.setOsMajorVersion(this.majorVersion[index]);
        e.setOsMinorVersion(this.minorVersion[index]);
        if (this.assemblyRefAssemblyRefIndex[index] > 0) {
            e.setAssemblyRef(model.assemblyRef[this.assemblyRefAssemblyRefIndex[index] - 1]);
        }
    }
}

