/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.AssemblyOsEntry;
import at.pollaknet.api.facile.util.ByteReader;

public class AssemblyOsTable
extends AbstractTable {
    public static final int TABLE_INDEX = 34;
    public static final int MIN_TABLE_SIZE = 12;
    private long[] platformID;
    private long[] majorVersion;
    private long[] minorVersion;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.platformID = new long[this.rows];
        this.majorVersion = new long[this.rows];
        this.minorVersion = new long[this.rows];
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        this.platformID[row] = ByteReader.getUInt32(data, offset);
        this.majorVersion[row] = ByteReader.getUInt32(data, offset += 4);
        this.minorVersion[row] = ByteReader.getUInt32(data, offset += 4);
        rowSize = (offset += 4) - rowSize;
        assert (rowSize == 12);
        return rowSize;
    }

    @Override
    protected String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" AssemblyOS Table (34):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  Platform ID: ");
            buffer.append(this.platformID[i]);
            buffer.append("\tMajorVersion: ");
            buffer.append(this.majorVersion[i]);
            buffer.append("\tMinorVersion: ");
            buffer.append(this.minorVersion[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 34;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        AssemblyOsEntry e = (AssemblyOsEntry)entry[index];
        e.setOsPlatformId(this.platformID[index]);
        e.setOsMajorVersion(this.majorVersion[index]);
        e.setOsMinorVersion(this.minorVersion[index]);
    }
}

