/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTable {
    protected int rows;
    protected byte stringIndexSize;
    protected byte blobIndexSize;
    protected byte guidIndexSize;
    protected boolean isVersion_1_1_MetadataStream = false;

    public int readRows(byte[] data, int offset, int[] numberOfRows, MetadataStream m) {
        long rowsLong = numberOfRows[this.getRID()];
        assert (rowsLong >= 0L);
        assert (rowsLong <= Integer.MAX_VALUE);
        this.rows = (int)rowsLong;
        if (this.rows == 0) {
            return 0;
        }
        this.stringIndexSize = m.getByteSizeOfStringIndices();
        this.blobIndexSize = m.getByteSizeOfBlobIndices();
        this.guidIndexSize = m.getByteSizeOfGuidIndices();
        this.isVersion_1_1_MetadataStream = m.getMajorVersion() == 1 && m.getMinorVersion() == 1;
        int consumedBytes = offset;
        this.prepareTable(numberOfRows);
        for (int i = 0; i < this.rows; ++i) {
            offset += this.readRow(data, offset, i);
        }
        consumedBytes = offset - consumedBytes;
        return consumedBytes;
    }

    protected int readStringIndex(byte[] data, int offset, int[] indexRow, int row) {
        return this.readIndex(data, offset, indexRow, row, this.stringIndexSize);
    }

    protected int readGuidIndex(byte[] data, int offset, int[] indexRow, int row) {
        return this.readIndex(data, offset, indexRow, row, this.guidIndexSize);
    }

    protected int readBlobIndex(byte[] data, int offset, int[] indexRow, int row) {
        return this.readIndex(data, offset, indexRow, row, this.blobIndexSize);
    }

    protected int readIndex(byte[] data, int offset, int[] indexRow, int row, byte sizeOfIndex) {
        if (sizeOfIndex == 4) {
            long value = ByteReader.getUInt32(data, offset);
            assert (value <= Integer.MAX_VALUE);
            indexRow[row] = (int)value;
            return 4;
        }
        if (sizeOfIndex == 2) {
            indexRow[row] = ByteReader.getUInt16(data, offset);
            return 2;
        }
        indexRow[row] = ByteReader.getUInt8(data, offset);
        return 1;
    }

    protected int readIndex(byte[] data, int offset, long[] indexRow, int row, byte sizeOfIndex) {
        if (sizeOfIndex == 4) {
            indexRow[row] = ByteReader.getUInt32(data, offset);
            return 4;
        }
        if (sizeOfIndex == 2) {
            indexRow[row] = ByteReader.getUInt16(data, offset);
            return 2;
        }
        indexRow[row] = ByteReader.getUInt8(data, offset);
        return 1;
    }

    public int getNumberOfRows() {
        return this.rows;
    }

    public void fill(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry) {
        for (int i = 0; i < this.rows; ++i) {
            this.fillRow(model, m, s, u, g, b, entry, i);
        }
    }

    public String toString() {
        return this.createTableRepresentation();
    }

    protected static void Log(Level logLevel, String message) {
        Logger logger = Logger.getLogger("at.pollaknet.api.facile");
        logger.log(logLevel, message);
    }

    public abstract int getRID();

    protected abstract void prepareTable(int[] var1);

    protected abstract int readRow(byte[] var1, int var2, int var3);

    protected abstract String createTableRepresentation();

    protected abstract void fillRow(MetadataModel var1, MetadataStream var2, StringsStream var3, UserStringStream var4, GuidStream var5, BlobStream var6, RenderableCilElement[] var7, int var8);
}

