/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ByteReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserStringStream
implements IDataHeader {
    private int byteSize;
    private HashMap<Integer, String> userStringHeap;
    Integer[] sortedKeySet = null;
    private String USER_STRING_DECODING_STANDARD = "UTF16";

    public UserStringStream(int size) {
        this.byteSize = size;
        this.userStringHeap = new HashMap();
    }

    @Override
    public int getSize() {
        return this.byteSize;
    }

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        int index;
        int lengthInfo;
        int maxIndex = offset + this.byteSize;
        int length = 0;
        byte[] utf16String = null;
        for (index = offset + 1; index < maxIndex; index += length + lengthInfo) {
            length = ByteReader.readHeapObjectSize(data, index);
            lengthInfo = ByteReader.getSizeOfHeapLength(length);
            if (length <= 0 || index + length + lengthInfo > maxIndex) continue;
            try {
                utf16String = ByteReader.getUTF16PreparedBytes(data, index + lengthInfo, length - 1);
                if (utf16String != null) {
                    this.userStringHeap.put(index - offset, new String(utf16String, this.USER_STRING_DECODING_STANDARD));
                    continue;
                }
                this.userStringHeap.put(index - offset, null);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger("at.pollaknet.api.facile").logp(Level.WARNING, "UserStringStream", "read", "Unable to decode the user string at position " + index + " (length: " + length + ") using " + this.USER_STRING_DECODING_STANDARD);
            }
        }
        this.byteSize = index - offset;
        return this.byteSize;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("#US Stream (UserString Heap):");
        if (this.userStringHeap.size() > 0) {
            this.ensureSortedKeySet();
            for (Integer key : this.sortedKeySet) {
                String value = this.userStringHeap.get(key);
                value = value == null ? "null" : value.replaceAll("\\p{Cntrl}", ".");
                buffer.append(String.format("\n%10d:\t%s", key, value));
            }
        }
        return buffer.toString();
    }

    public String getName() {
        return "#US";
    }

    private void ensureSortedKeySet() {
        if (this.sortedKeySet == null || this.sortedKeySet.length != this.userStringHeap.size()) {
            Set<Integer> var = this.userStringHeap.keySet();
            this.sortedKeySet = var.toArray(new Integer[var.size()]);
            Arrays.sort((Object[])this.sortedKeySet);
        }
    }

    public String getUserString(int byteIndex) {
        return this.userStringHeap.get(byteIndex);
    }

    public String getUserStringByDecodedToken(int decodedToken) {
        this.ensureSortedKeySet();
        if (decodedToken >= 0 && decodedToken < this.sortedKeySet.length) {
            return this.userStringHeap.get((int)this.sortedKeySet[decodedToken]);
        }
        return null;
    }
}

