/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ArrayUtils;

public class UnknownStream
implements IDataHeader {
    private String name;
    private int size;
    private int offset;
    private byte[] content;
    private boolean valid;

    public UnknownStream(String name, int streamSize) {
        this.name = name;
        this.size = streamSize;
        this.valid = false;
    }

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        if (this.size + offset > data.length) {
            return 0;
        }
        this.content = new byte[this.size];
        System.arraycopy(data, offset, this.content, 0, this.size);
        this.offset = offset;
        this.valid = true;
        return this.size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public String toString() {
        return this.getName() + " Stream";
    }

    public String toExtendedString() {
        if (!this.valid) {
            return this.toString() + " (invalid)";
        }
        return this.toString() + " (Unknown Stream Type):\n" + ArrayUtils.formatAsHexTable(this.offset, this.content, true);
    }

    public String getName() {
        return this.name;
    }

    public byte[] getContent() {
        return this.content;
    }
}

