/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class StringsStream
implements IDataHeader {
    private int byteSize;
    private HashMap<Integer, byte[]> stringHeap;
    Integer[] sortedKeySet = null;

    public StringsStream(int size) {
        this.byteSize = size;
        this.stringHeap = new HashMap();
    }

    @Override
    public int getSize() {
        return this.byteSize;
    }

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        int index;
        int length;
        for (index = offset + 1; index < offset + this.byteSize; index += length + 1) {
            length = ArrayUtils.findInByteArray(data, index, (byte)0);
            if (length < 0) {
                return index - offset;
            }
            if (length <= 0) continue;
            this.stringHeap.put(index - offset, ByteReader.getBytes(data, index, length));
        }
        this.byteSize = index - offset;
        return this.byteSize;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("#Strings Stream (String Heap):");
        if (this.stringHeap.size() > 0) {
            this.ensureSortedKeySet();
            for (Integer key : this.sortedKeySet) {
                String value = new String(this.stringHeap.get(key));
                value = value.replaceAll("\\p{Cntrl}", ".");
                buffer.append(String.format("\n%10d:\t%s", key, value));
            }
        }
        return buffer.toString();
    }

    public String getName() {
        return "#Strings";
    }

    public String getString(int byteIndex) {
        byte[] searchBuffer = this.stringHeap.get(byteIndex);
        if (searchBuffer == null && byteIndex != 0) {
            int startIndex;
            int lastElementSize;
            this.ensureSortedKeySet();
            int lastIndex = this.sortedKeySet[this.sortedKeySet.length - 1];
            byte[] lastElement = this.stringHeap.get(lastIndex);
            int n = lastElementSize = lastElement == null ? 0 : lastElement.length;
            if (byteIndex >= lastIndex + lastElementSize) {
                return null;
            }
            Integer prevValue = this.sortedKeySet[0];
            Integer currentValue = this.sortedKeySet[0];
            for (Integer key : this.sortedKeySet) {
                if (byteIndex < key) {
                    currentValue = key;
                    break;
                }
                prevValue = key;
            }
            searchBuffer = (searchBuffer = this.stringHeap.get((int)prevValue)).length <= (startIndex = byteIndex - prevValue) ? this.stringHeap.get((int)currentValue) : Arrays.copyOfRange(searchBuffer, startIndex, searchBuffer.length);
        }
        return searchBuffer == null ? null : new String(searchBuffer);
    }

    private void ensureSortedKeySet() {
        if (this.sortedKeySet == null || this.sortedKeySet.length != this.stringHeap.size()) {
            Set<Integer> var = this.stringHeap.keySet();
            this.sortedKeySet = var.toArray(new Integer[var.size()]);
            Arrays.sort((Object[])this.sortedKeySet);
        }
    }

    public String getStringByDecodedToken(int decodedToken) {
        this.ensureSortedKeySet();
        if (decodedToken >= 0 && decodedToken < this.sortedKeySet.length) {
            return new String(this.stringHeap.get((int)this.sortedKeySet[decodedToken]));
        }
        return null;
    }
}

