/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.AssemblyOsTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.AssemblyProcessorTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.AssemblyRefOsTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.AssemblyRefProcessorTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.AssemblyRefTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.AssemblyTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ClassLayoutTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ConstantTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.CustomAttributeTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.DeclSecurityTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.EncLogTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.EncMapTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.EventMapTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.EventPtrTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.EventTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ExportedTypeTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.FieldLayoutTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.FieldMarshalTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.FieldPtrTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.FieldRVATable;
import at.pollaknet.api.facile.header.cli.stream.metatable.FieldTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.FileTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.GenericParamConstraintTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.GenericParamTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ImplMapTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.InterfaceImplTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ManifestResourceTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.MemberRefTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.MethodDefTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.MethodImplTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.MethodPtrTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.MethodSemanticsTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.MethodSpecTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ModuleRefTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ModuleTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.NestedClassTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ParamPtrTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.ParamTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.PropertyMapTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.PropertyPtrTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.PropertyTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.StandAloneSigTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.TypeDefTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.TypeRefTable;
import at.pollaknet.api.facile.header.cli.stream.metatable.TypeSpecTable;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetadataStream
implements IDataHeader {
    public static final int MIN_STREAM_SIZE = 24;
    public static final int MAX_NUMBER_OF_TABLES = 64;
    public static final int HEAPS_FLAGS_4BYTE_STRING_HEAP = 1;
    public static final int HEAPS_FLAGS_4BYTE_GUID_HEAP = 2;
    public static final int HEAPS_FLAGS_4BYTE_BLOB_HEAP = 4;
    public static final int HEAPS_FLAGS_UNOPTIMIZED_EDIT_AND_CONTINUE_DATA = 32;
    public static final int HEAPS_FLAGS_UNOPTIMIZED_CAN_CONTAIN_DELETED_DATA = 128;
    private long reservedValue;
    private int majorVersion;
    private int minorVersion;
    private int heaps;
    private int widthOfMaxRid;
    private long validMaskLow;
    private long validMaskHigh;
    private long sortedLow;
    private long sortedHigh;
    private int[] numberOfRows;
    private int byteSize;
    private AbstractTable[] metadataTable = new AbstractTable[64];
    private int[] emptyTablesIndices = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final byte SIZE_OF_LARGE_INDEX = 4;
    private static final byte SIZE_OF_SMALL_INDEX = 2;
    private boolean isUnoptimized;

    public MetadataStream(boolean isUnoptimized) {
        this.isUnoptimized = isUnoptimized;
        this.metadataTable[0] = new ModuleTable();
        this.metadataTable[1] = new TypeRefTable();
        this.metadataTable[2] = new TypeDefTable();
        this.metadataTable[3] = new FieldPtrTable();
        this.metadataTable[4] = new FieldTable();
        this.metadataTable[5] = new MethodPtrTable();
        this.metadataTable[6] = new MethodDefTable();
        this.metadataTable[7] = new ParamPtrTable();
        this.metadataTable[8] = new ParamTable();
        this.metadataTable[9] = new InterfaceImplTable();
        this.metadataTable[10] = new MemberRefTable();
        this.metadataTable[11] = new ConstantTable();
        this.metadataTable[12] = new CustomAttributeTable();
        this.metadataTable[13] = new FieldMarshalTable();
        this.metadataTable[14] = new DeclSecurityTable();
        this.metadataTable[15] = new ClassLayoutTable();
        this.metadataTable[16] = new FieldLayoutTable();
        this.metadataTable[17] = new StandAloneSigTable();
        this.metadataTable[18] = new EventMapTable();
        this.metadataTable[19] = new EventPtrTable();
        this.metadataTable[20] = new EventTable();
        this.metadataTable[21] = new PropertyMapTable();
        this.metadataTable[22] = new PropertyPtrTable();
        this.metadataTable[23] = new PropertyTable();
        this.metadataTable[24] = new MethodSemanticsTable();
        this.metadataTable[25] = new MethodImplTable();
        this.metadataTable[26] = new ModuleRefTable();
        this.metadataTable[27] = new TypeSpecTable();
        this.metadataTable[28] = new ImplMapTable();
        this.metadataTable[29] = new FieldRVATable();
        this.metadataTable[30] = new EncLogTable();
        this.metadataTable[31] = new EncMapTable();
        this.metadataTable[32] = new AssemblyTable();
        this.metadataTable[33] = new AssemblyProcessorTable();
        this.metadataTable[34] = new AssemblyOsTable();
        this.metadataTable[35] = new AssemblyRefTable();
        this.metadataTable[36] = new AssemblyRefProcessorTable();
        this.metadataTable[37] = new AssemblyRefOsTable();
        this.metadataTable[38] = new FileTable();
        this.metadataTable[39] = new ExportedTypeTable();
        this.metadataTable[40] = new ManifestResourceTable();
        this.metadataTable[41] = new NestedClassTable();
        this.metadataTable[42] = new GenericParamTable();
        this.metadataTable[43] = new MethodSpecTable();
        this.metadataTable[44] = new GenericParamConstraintTable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        void var9_8;
        long value;
        void var9_6;
        this.byteSize = offset;
        offset += this.readStaticHeader(data, offset);
        this.numberOfRows = new int[64];
        long high = this.validMaskHigh;
        long low = this.validMaskLow;
        boolean bl = false;
        while (var9_6 < 32) {
            if ((low & 1L) == 1L) {
                value = ByteReader.getUInt32(data, offset);
                assert (value <= Integer.MAX_VALUE);
                this.numberOfRows[var9_6] = (int)value;
                offset += 4;
            } else {
                this.numberOfRows[var9_6] = 0;
            }
            low >>= 1;
            ++var9_6;
        }
        int n = 32;
        while (var9_8 < 64) {
            if ((high & 1L) == 1L) {
                value = ByteReader.getUInt32(data, offset);
                assert (value <= Integer.MAX_VALUE);
                this.numberOfRows[var9_8] = (int)value;
                offset += 4;
            } else {
                this.numberOfRows[var9_8] = 0;
            }
            high >>= 1;
            ++var9_8;
        }
        for (AbstractTable t : this.metadataTable) {
            if (t == null) continue;
            offset += t.readRows(data, offset, this.numberOfRows, this);
        }
        for (int index : this.emptyTablesIndices) {
            if (this.numberOfRows[index] == 0) continue;
            Logger logger = Logger.getLogger("at.pollaknet.api.facile");
            String msg = String.format("Found %d entries in unknown metadata table 0x%x!", this.numberOfRows[index], index);
            logger.log(Level.WARNING, msg);
        }
        offset = ByteReader.alignToDWord(offset);
        this.byteSize = offset - this.byteSize;
        assert (this.byteSize >= 24);
        return this.byteSize;
    }

    private int readStaticHeader(byte[] data, int offset) {
        int consumedBytes = offset;
        this.reservedValue = ByteReader.getUInt32(data, offset);
        this.majorVersion = ByteReader.getUInt8(data, offset += 4);
        this.minorVersion = ByteReader.getUInt8(data, ++offset);
        this.heaps = ByteReader.getUInt8(data, ++offset);
        this.widthOfMaxRid = ByteReader.getUInt8(data, ++offset);
        this.validMaskLow = ByteReader.getUInt32(data, ++offset);
        this.validMaskHigh = ByteReader.getUInt32(data, offset += 4);
        this.sortedLow = ByteReader.getUInt32(data, offset += 4);
        this.sortedHigh = ByteReader.getUInt32(data, offset += 4);
        assert ((offset += 4) - consumedBytes == 24);
        return offset - consumedBytes;
    }

    @Override
    public int getSize() {
        return this.byteSize;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getName());
        buffer.append(" Stream (Metadata):");
        buffer.append(String.format("\n\n  Major Version: ........%010d", this.majorVersion));
        buffer.append(String.format("\n  Minor Version: ........%010d", this.minorVersion));
        buffer.append(String.format("\n  Heaps: ................%010d", this.heaps));
        buffer.append(String.format("\n  Width of max RID: .....0x%04x", this.widthOfMaxRid));
        buffer.append(String.format("\n  Valid Mask (low): .....0x%08x", this.validMaskLow));
        buffer.append(String.format("\n  Valid Mask (high): ....0x%08x", this.validMaskHigh));
        buffer.append(String.format("\n  Sorted (low): .........0x%08x", this.sortedLow));
        buffer.append(String.format("\n  Sorted (high): ........0x%08x", this.sortedHigh));
        buffer.append("\n\n\n  Tables:\n");
        for (int i = 0; i < 64; ++i) {
            if (i % 4 == 0) {
                buffer.append("\n");
            }
            buffer.append(String.format("    Table 0x%02x: %-5d", i, this.numberOfRows[i]));
        }
        return buffer.toString();
    }

    public String toExtendedString(int ... table) {
        StringBuffer buffer = new StringBuffer(this.toString());
        if (table.length == 0) {
            for (AbstractTable t : this.metadataTable) {
                if (t == null || this.numberOfRows[t.getRID()] == 0) continue;
                buffer.append("\n");
                buffer.append(t.toString());
            }
        } else {
            for (AbstractTable t : this.metadataTable) {
                if (t == null || !ArrayUtils.contains(table, t.getRID())) continue;
                buffer.append("\n");
                buffer.append(t.toString());
            }
        }
        return buffer.toString();
    }

    public String getName() {
        return this.isUnoptimized ? "#-" : "#~";
    }

    public byte getByteSizeOfStringIndices() {
        return (this.heaps & 1) == 1 ? (byte)4 : 2;
    }

    public byte getByteSizeOfGuidIndices() {
        return (this.heaps & 2) == 2 ? (byte)4 : 2;
    }

    public byte getByteSizeOfBlobIndices() {
        return (this.heaps & 4) == 4 ? (byte)4 : 2;
    }

    public AbstractTable[] getMetadataTable() {
        return this.metadataTable;
    }

    public boolean isUnoptimized() {
        return this.isUnoptimized;
    }

    public int getWidthOfMaxRid() {
        return this.widthOfMaxRid;
    }

    public long getReservedValue() {
        return this.reservedValue;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getHeaps() {
        return this.heaps;
    }

    public long getValidMaskLow() {
        return this.validMaskLow;
    }

    public long getValidMaskHigh() {
        return this.validMaskHigh;
    }

    public long getSortedHigh() {
        return this.sortedHigh;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public int[] getEmptyTablesIndices() {
        return this.emptyTablesIndices;
    }
}

