/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.ArrayList;

public class GuidStream
implements IDataHeader {
    private int byteSize;
    private ArrayList<byte[]> guidHeap;
    public static final int GUID_BYTE_SIZE = 16;

    public GuidStream(int size) {
        this.byteSize = size;
        this.guidHeap = new ArrayList();
    }

    @Override
    public int getSize() {
        return this.byteSize;
    }

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        int index;
        for (index = offset; index < offset + this.byteSize; index += 16) {
            this.guidHeap.add(ByteReader.getBytes(data, index, 16));
        }
        this.byteSize = index - offset;
        return this.byteSize;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("#GUID Stream (Globally Unique Identifier Heap):");
        int index = 0;
        for (byte[] guid : this.guidHeap) {
            buffer.append("\n ");
            buffer.append(index);
            buffer.append(":\t");
            buffer.append(ArrayUtils.formatByteArray(guid));
            ++index;
        }
        return buffer.toString();
    }

    public byte[] getGuid(int index) {
        if (--index < 0 || index >= this.guidHeap.size()) {
            return null;
        }
        return this.guidHeap.get(index);
    }

    public String getName() {
        return "#GUID";
    }
}

