/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class BlobStream
implements IDataHeader {
    private int byteSize;
    private HashMap<Integer, byte[]> blobHeap;

    public BlobStream(int size) {
        this.byteSize = size;
        this.blobHeap = new HashMap();
    }

    @Override
    public int getSize() {
        return this.byteSize;
    }

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        int index;
        int lengthInfo;
        int length;
        int maxIndex = offset + this.byteSize;
        for (index = offset + 1; index < maxIndex; index += length + lengthInfo) {
            length = ByteReader.readHeapObjectSize(data, index);
            lengthInfo = ByteReader.getSizeOfHeapLength(length);
            if (length < 0 || index + length + lengthInfo > maxIndex) continue;
            byte[] binarySignature = ByteReader.getBytes(data, index + lengthInfo, length);
            this.blobHeap.put(index - offset, binarySignature);
        }
        this.byteSize = index - offset;
        return this.byteSize;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("#Blob Stream (Blob Heap):");
        if (this.blobHeap.size() > 0) {
            Set<Integer> var = this.blobHeap.keySet();
            Object[] keySet = var.toArray(new Integer[var.size()]);
            Arrays.sort(keySet);
            for (Object key : keySet) {
                String value = ArrayUtils.formatAsHexTable(this.blobHeap.get(key), false);
                buffer.append(String.format("\n%10d:\t%s", key, value));
            }
        }
        return buffer.toString();
    }

    public byte[] getBlob(int byteIndex) {
        return this.blobHeap.get(byteIndex);
    }

    public String getName() {
        return "#Blob";
    }
}

