/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;

public class StreamHeader
implements IDataHeader {
    public static final int MIN_HEADER_SIZE = 8;
    private long streamOffset;
    private long streamSize;
    private String name;
    private int headerSize = 0;
    private boolean isUnoptimized;

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        this.headerSize = offset--;
        int hashPos = 0;
        int termPos = 0;
        do {
            hashPos = ArrayUtils.findInByteArray(data, ++offset + 8, (byte)35);
            termPos = ArrayUtils.findInByteArray(data, offset + 8 + hashPos, (byte)0);
            byte[] buffer = ByteReader.getBytes(data, offset + 8 + hashPos, termPos);
            assert (buffer != null);
            boolean valid = true;
            for (byte b : buffer) {
                if (b >= 32) continue;
                valid = false;
            }
            if (!valid) continue;
            this.name = new String(buffer);
        } while (this.name == null || !this.name.startsWith("#") || this.name.length() < 2);
        this.streamOffset = ByteReader.getUInt32(data, offset += hashPos);
        this.streamSize = ByteReader.getUInt32(data, offset += 4);
        int length = ArrayUtils.findInByteArray(data, offset += 4, (byte)0);
        if (length > 0) {
            this.name = new String(ByteReader.getBytes(data, offset, length));
            if (this.name.equals("#-")) {
                this.isUnoptimized = true;
            }
        }
        this.headerSize = (offset += length) - this.headerSize;
        assert (this.headerSize >= 8);
        return this.headerSize;
    }

    @Override
    public int getSize() {
        return this.headerSize;
    }

    public long getStreamOffset() {
        return this.streamOffset;
    }

    public long getStreamSize() {
        return this.streamSize;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("Offset: ...0x%08x; Size: ...0x%08x; Name: ...%s", this.streamOffset, this.streamSize, this.name.replaceAll("\\p{Cntrl}", "."));
    }

    public boolean isUnoptimized() {
        return this.isUnoptimized;
    }
}

