/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.header.cli.StreamHeader;
import at.pollaknet.api.facile.util.ByteReader;

public class CliMetadataRootHeader
implements IDataHeader {
    private static final int MIN_HEADER_SIZE = 20;
    private static final long CLR_METADATA_SIGNATURE = 1112167234L;
    private long signature;
    private int majorVersion;
    private int minorVersion;
    private long extraDataOffset;
    private long versionStringLength;
    private String versionString;
    private int flags;
    private int numberOfStreams;
    private StreamHeader[] streams = null;
    private int headerSize = 0;
    private boolean isUnoptimized = false;

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        this.headerSize = offset;
        this.signature = ByteReader.getUInt32(data, offset);
        if (this.signature != 1112167234L) {
            throw new UnexpectedHeaderDataException("Unknown signature: " + this.signature + "(expected " + 1112167234L + ")");
        }
        this.majorVersion = ByteReader.getUInt16(data, offset += 4);
        this.minorVersion = ByteReader.getUInt16(data, offset += 2);
        this.extraDataOffset = ByteReader.getUInt32(data, offset += 2);
        this.versionStringLength = ByteReader.getUInt32(data, offset += 4);
        offset += 4;
        assert (this.versionStringLength < Integer.MAX_VALUE);
        assert (this.versionStringLength > 0L);
        this.versionString = new String(ByteReader.getBytes(data, offset, (int)this.versionStringLength));
        offset = (int)((long)offset + this.versionStringLength);
        this.flags = ByteReader.getUInt16(data, offset);
        this.numberOfStreams = ByteReader.getUInt16(data, offset += 2);
        offset += 2;
        this.streams = new StreamHeader[this.numberOfStreams];
        for (int i = 0; i < this.numberOfStreams; ++i) {
            this.streams[i] = new StreamHeader();
            offset += this.streams[i].read(data, offset);
            if (!this.streams[i].isUnoptimized()) continue;
            this.isUnoptimized = true;
        }
        this.headerSize = offset - this.headerSize;
        assert (this.headerSize >= 20);
        return this.headerSize;
    }

    @Override
    public int getSize() {
        return this.headerSize;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getNumberOfStreams() {
        return this.numberOfStreams;
    }

    public long getExtraDataOffset() {
        return this.extraDataOffset;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public StreamHeader[] getStreamHeaders() {
        return this.streams;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Metadata Root Header:");
        buffer.append(String.format("\n  Header Size: ..........%010d", this.headerSize));
        buffer.append(String.format("\n  Major Version: ........%010d", this.majorVersion));
        buffer.append(String.format("\n  Minor Version: ........%010d", this.minorVersion));
        buffer.append(String.format("\n  Extra Data Offset: ....0x%08x", this.extraDataOffset));
        buffer.append(String.format("\n  Version String: .......%s", this.versionString.replaceAll("\\p{Cntrl}", "_")));
        buffer.append(String.format("\n  Flags: ................0x%08x", this.flags));
        buffer.append(String.format("\n  Number of Streams: ....%010d", this.numberOfStreams));
        buffer.append("\n\n  Stream Headers:");
        if (this.streams != null) {
            for (StreamHeader h : this.streams) {
                buffer.append("\n    ");
                buffer.append(h.toString());
            }
        }
        buffer.append("\n\n  Unoptimized Assembly: .").append(this.isUnoptimized);
        return buffer.toString();
    }

    public boolean isUnoptimized() {
        return this.isUnoptimized;
    }
}

