/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ByteReader;

public class CliHeader
implements IDataHeader {
    public static final int FLAGS_IL_ONLY = 1;
    public static final int FLAGS_32_BIT_REQUIRED = 2;
    public static final int FLAGS_IL_LIBRARY = 4;
    public static final int FLAGS_STRONG_NAME_SIGNATURE = 8;
    public static final int FLAGS_NATIVE_ENTRY_POINT = 16;
    public static final int FLAGS_TRACK_DEBUG_DATA = 65536;
    public static final int STATIC_HEADER_SIZE = 72;
    private long clrHeaderSize;
    private int majorRuntimeVersion;
    private int minorRuntimeVersion;
    private long addrOfMetadataDirectory;
    private long sizeOfMetadataDirectory;
    private long flags;
    private long entryPointToken;
    private long addrOfResourcesDirectory;
    private long sizeOfResourcesDirectory;
    private long addrOfStrongNameSignature;
    private long sizeOfStrongNameSignature;
    private long addrOfCodeManagerTable;
    private long sizeOfCodeManagerTable;
    private long addrOfVTableFixupDirectory;
    private long sizeOfVTableFixupDirectory;
    private long addrOfExportAddressTable;
    private long sizeOfExportAddressTable;
    private long addrOfPrecompiledHeader;
    private long sizeOfPrecompiledHeader;
    private int headerSize;

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        this.headerSize = offset;
        this.clrHeaderSize = ByteReader.getUInt32(data, offset);
        this.majorRuntimeVersion = ByteReader.getUInt16(data, offset += 4);
        this.minorRuntimeVersion = ByteReader.getUInt16(data, offset += 2);
        this.addrOfMetadataDirectory = ByteReader.getUInt32(data, offset += 2);
        this.sizeOfMetadataDirectory = ByteReader.getUInt32(data, offset += 4);
        this.flags = ByteReader.getUInt32(data, offset += 4);
        this.entryPointToken = ByteReader.getUInt32(data, offset += 4);
        this.addrOfResourcesDirectory = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfResourcesDirectory = ByteReader.getUInt32(data, offset += 4);
        this.addrOfStrongNameSignature = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfStrongNameSignature = ByteReader.getUInt32(data, offset += 4);
        this.addrOfCodeManagerTable = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfCodeManagerTable = ByteReader.getUInt32(data, offset += 4);
        this.addrOfVTableFixupDirectory = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfVTableFixupDirectory = ByteReader.getUInt32(data, offset += 4);
        this.addrOfExportAddressTable = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfExportAddressTable = ByteReader.getUInt32(data, offset += 4);
        this.addrOfPrecompiledHeader = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfPrecompiledHeader = ByteReader.getUInt32(data, offset += 4);
        this.headerSize = (offset += 4) - this.headerSize;
        assert (this.headerSize == 72);
        return this.headerSize;
    }

    @Override
    public int getSize() {
        return 72;
    }

    public long getClrHeaderSize() {
        return this.clrHeaderSize;
    }

    public int getMajorRuntimeVersion() {
        return this.majorRuntimeVersion;
    }

    public int getMinorRuntimeVersion() {
        return this.minorRuntimeVersion;
    }

    public long getAddrOfMetadataDirectory() {
        return this.addrOfMetadataDirectory;
    }

    public long getSizeOfMetadataDirectory() {
        return this.sizeOfMetadataDirectory;
    }

    public long getFlags() {
        return this.flags;
    }

    public String toString() {
        return "PE Data Directories:" + String.format("\n  Major Runtime Version: ...............%05d", this.majorRuntimeVersion) + String.format("\n  Minor Runtime Version: ...............%05d", this.minorRuntimeVersion) + String.format("\n  Address of Metadata Directory: .......0x%08x", this.addrOfMetadataDirectory) + String.format("\n  Size of Metadata Directory: ..........%010d", this.sizeOfMetadataDirectory) + String.format("\n  Flags: ...............................0x%08x", this.flags) + String.format("\n  Entry Point Token: ...................0x%08x", this.entryPointToken) + String.format("\n  Address of Resources Directory: ......0x%08x", this.addrOfResourcesDirectory) + String.format("\n  Size of Resources Directory: .........%010d", this.sizeOfResourcesDirectory) + String.format("\n  Address of Strong Name Signature: ....0x%08x", this.addrOfStrongNameSignature) + String.format("\n  Size of Strong Name Signature: .......%010d", this.sizeOfStrongNameSignature) + String.format("\n  Address of Code Manager Table: .......0x%08x", this.addrOfCodeManagerTable) + String.format("\n  Size of Code Manager Table: ..........%010d", this.sizeOfCodeManagerTable) + String.format("\n  Address of VTable Fixup Directory: ...0x%08x", this.addrOfVTableFixupDirectory) + String.format("\n  Size of VTable Fixup Directory: ......%010d", this.sizeOfVTableFixupDirectory) + String.format("\n  Address of Strong Name Signature: ....0x%08x", this.addrOfExportAddressTable) + String.format("\n  Size of Strong Name Signature: .......%010d", this.sizeOfExportAddressTable) + String.format("\n  Address of Precompiled Header: .......0x%08x", this.addrOfPrecompiledHeader) + String.format("\n  Size of Precompiled Header: ..........%010d", this.sizeOfPrecompiledHeader);
    }

    public long getAddrOfResourcesDirectory() {
        return this.addrOfResourcesDirectory;
    }

    public long getSizeOfResourcesDirectory() {
        return this.sizeOfResourcesDirectory;
    }

    public long getAddrOfStrongNameSignature() {
        return this.addrOfStrongNameSignature;
    }

    public long getSizeOfStrongNameSignature() {
        return this.sizeOfStrongNameSignature;
    }

    public long getAddrOfCodeManagerTable() {
        return this.addrOfCodeManagerTable;
    }

    public long getSizeOfCodeManagerTable() {
        return this.sizeOfCodeManagerTable;
    }

    public long getAddrOfVTableFixupDirectory() {
        return this.addrOfVTableFixupDirectory;
    }

    public long getSizeOfVTableFixupDirectory() {
        return this.sizeOfVTableFixupDirectory;
    }

    public long getAddrOfExportAddressTable() {
        return this.addrOfExportAddressTable;
    }

    public long getSizeOfExportAddressTable() {
        return this.sizeOfExportAddressTable;
    }

    public long getAddrOfPrecompiledHeader() {
        return this.addrOfPrecompiledHeader;
    }

    public long getSizeOfPrecompiledHeader() {
        return this.sizeOfPrecompiledHeader;
    }

    public long getEntryPointToken() {
        return this.entryPointToken;
    }
}

