/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.prefix;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class Unaligned
extends CilInstruction {
    public static final byte SECOND_TOKEN = 18;
    public static final byte BYTE_SIZE = 3;
    private short alignment;

    @Override
    public String render(LanguageRenderer renderer) {
        return this.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        Unaligned.ensure(buffer, index, (byte)-2);
        Unaligned.ensure(buffer, index + 1, (byte)18);
        this.alignment = ByteReader.getUInt8(buffer, index + 2);
        return 3;
    }

    public short getAlignment() {
        return this.alignment;
    }

    public String toString() {
        return "unaligned." + this.alignment;
    }

    @Override
    public byte getByteSize() {
        return 3;
    }

    @Override
    public byte getFirstToken() {
        return -2;
    }

    @Override
    public byte getSecondToken() {
        return 18;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Unaligned)obj).alignment == this.alignment;
    }

    @Override
    public int hashCode() {
        return 1447 + this.alignment;
    }
}

