/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.prefix;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class No
extends CilInstruction {
    public static final byte SECOND_TOKEN = 25;
    public static final byte BYTE_SIZE = 3;
    private byte checkType;

    @Override
    public String render(LanguageRenderer renderer) {
        return this.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        No.ensure(buffer, index, (byte)-2);
        No.ensure(buffer, index + 1, (byte)25);
        this.checkType = ByteReader.getInt8(buffer, index + 2);
        return 3;
    }

    public byte getCheckType() {
        return this.checkType;
    }

    public String toString() {
        switch (this.checkType) {
            case 1: {
                return "no.typecheck";
            }
            case 2: {
                return "no.rangecheck";
            }
            case 4: {
                return "no.nullcheck";
            }
        }
        assert (false);
        return "";
    }

    @Override
    public byte getByteSize() {
        return 3;
    }

    @Override
    public byte getFirstToken() {
        return -2;
    }

    @Override
    public byte getSecondToken() {
        return 25;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((No)obj).checkType == this.checkType;
    }

    @Override
    public int hashCode() {
        return 1433 + this.checkType;
    }
}

