/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.prefix;

import at.pollaknet.api.facile.code.instruction.ReferenceCilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class Constrained
extends ReferenceCilInstruction {
    public static final byte SECOND_TOKEN = 22;
    public static final byte BYTE_SIZE = 6;

    @Override
    public String render(LanguageRenderer renderer) {
        return "constrained." + this.reference.renderAsReference(renderer);
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        Constrained.ensure(buffer, index, (byte)-2);
        Constrained.ensure(buffer, index + 1, (byte)22);
        this.token = ByteReader.getInt32(buffer, index + 2);
        this.reference = metaModel.getEntryByToken(this.token);
        return 6;
    }

    public String toString() {
        return "constrained. " + this.token;
    }

    @Override
    public byte getByteSize() {
        return 6;
    }

    @Override
    public byte getFirstToken() {
        return -2;
    }

    @Override
    public byte getSecondToken() {
        return 22;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Constrained)obj).token == this.token;
    }

    @Override
    public int hashCode() {
        return 1429 + this.token;
    }
}

