/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.object;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class Ldstr
extends CilInstruction {
    public static final byte FIRST_TOKEN = 114;
    public static final byte BYTE_SIZE = 5;
    private int token;
    private String str;

    @Override
    public String render(LanguageRenderer renderer) {
        if (this.str != null) {
            return "ldstr \"" + this.str + "\"";
        }
        return "ldstr null";
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        Ldstr.ensure(buffer, index, (byte)114);
        this.token = ByteReader.getInt32(buffer, index + 1);
        this.str = metaModel.getUserStringbyToken(this.token);
        return 5;
    }

    @Override
    public int getMetadataToken() {
        return this.token;
    }

    public String toString() {
        return "ldstr " + this.token;
    }

    @Override
    public byte getByteSize() {
        return 5;
    }

    @Override
    public byte getFirstToken() {
        return 114;
    }

    @Override
    public byte getSecondToken() {
        return -2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        String other = ((Ldstr)obj).str;
        if (this.str == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        return other.equals(this.str);
    }

    @Override
    public int hashCode() {
        return 1229 + this.token;
    }
}

