/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.base;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.ILAsmRenderer;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.Arrays;

public class Switch
extends CilInstruction {
    public static final byte FIRST_TOKEN = 69;
    private int byteSize;
    private int numCases;
    private int[] jumpTargets;

    @Override
    public String render(LanguageRenderer renderer) {
        assert (renderer instanceof ILAsmRenderer);
        StringBuffer buffer = new StringBuffer();
        buffer.append("switch (");
        for (int i = 0; i < this.numCases; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(((ILAsmRenderer)renderer).renderRelativeAsLabel(this.jumpTargets[i]));
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        Switch.ensure(buffer, index, (byte)69);
        long cases = ByteReader.getUInt32(buffer, index + 1);
        assert (cases <= Integer.MAX_VALUE);
        this.numCases = (int)cases;
        assert (this.numCases > 0);
        this.jumpTargets = new int[this.numCases];
        for (int i = 0; i < this.numCases; ++i) {
            this.jumpTargets[i] = ByteReader.getInt32(buffer, index + 5 + i * 4);
        }
        this.byteSize = 5 + this.numCases * 4;
        return this.byteSize;
    }

    public int getNumberOfCases() {
        return this.numCases;
    }

    public int[] getTargetAddresses() {
        return this.jumpTargets;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("switch (");
        for (int i = 0; i < this.numCases; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.jumpTargets[i]);
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public byte getByteSize() {
        if (this.byteSize > 127) {
            return -1;
        }
        return (byte)this.byteSize;
    }

    public int getExtendedByteSize() {
        return this.byteSize;
    }

    @Override
    public byte getFirstToken() {
        return 69;
    }

    @Override
    public byte getSecondToken() {
        return -2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Switch other = (Switch)obj;
        if (this.numCases != other.numCases) {
            return false;
        }
        return Arrays.equals(this.jumpTargets, other.jumpTargets);
    }

    @Override
    public int hashCode() {
        return 1033 + this.numCases;
    }
}

